
public class SalariedEmployee extends Employee
{
    private double salary; //annual

    public SalariedEmployee( )
    {
        super( );
        salary = 0;
    }

    public SalariedEmployee(String theName, int theAFM, double theSalary)
    {
         super(theName, theAFM);
         if (theSalary >= 0)
             salary = theSalary;
         else
         {
             System.out.println("Fatal Error: Negative salary.");
             System.exit(0);
         }
    }

    public SalariedEmployee(SalariedEmployee originalObject )
    {
         super(originalObject);
         salary = originalObject.salary;
    }

    public double getSalary( )
    {
        return salary;
    }

    /**
     Returns the pay for the month.
    */
    public double getPay( )
    {
        return salary/12;
    }

    public void setSalary(double newSalary)
    {
         if (newSalary >= 0)
             salary = newSalary;
         else
         {
             System.out.println("Fatal Error: Negative salary.");
             System.exit(0);
         }
    }

    public String toString( )
    {
        return (getName( ) + " " + getAFM( ) + "\n$" + salary + " per year");
    }

    public boolean equals(SalariedEmployee other)
    {
        return (getName( ).equals(other.getName( )) 
                && getAFM( ) == other.getAFM( )
                && salary == other.salary);
    }
}
