
public class HourlyEmployee extends Employee 
{
    private double wageRate; 
    private double hours; //for the month

    public HourlyEmployee( )
    {
        super( );
        wageRate = 0;
        hours = 0;
    }

	public HourlyEmployee(String theName, int theAFM)
    {
		//super(theName,theAFM);
		wageRate = 0;
        hours = 0;
    }
	
    public HourlyEmployee(String theName, int theAFM,
                       double theWageRate, double theHours)
    {
         super(theName, theAFM);
         if ((theWageRate >= 0) && (theHours >= 0))
         {
             wageRate = theWageRate;
             hours = theHours;
         }
         else
         {
             System.out.println(
                       "Fatal Error: creating an illegal hourly employee.");
             System.exit(0);
         }
    }

    public HourlyEmployee(HourlyEmployee originalObject)
    {
         super(originalObject);
         wageRate = originalObject.wageRate;
         hours = originalObject.hours;
    }

    public double getRate( )
    {
        return wageRate;
    }

    public double getHours( )
    {
        return hours;
    }

    /**
     Returns the pay for the month.
    */
    public double getPay( )
    {
        return wageRate*hours;
    }

    public void setHours(double hoursWorked)
    {
         if (hoursWorked >= 0)
             hours = hoursWorked;
         else
         {
             System.out.println("Fatal Error: Negative hours worked.");
             System.exit(0);
         }
     }

    public void setRate(double newWageRate)
    {
         if (newWageRate >= 0)
             wageRate = newWageRate;
         else
         {
             System.out.println("Fatal Error: Negative wage rate.");
             System.exit(0);
         }
    }

    public String toString( )
    {
        return (getName( ) + " " + getAFM( ) 
                + "\n$" + wageRate + " per hour for " + hours + " hours");
    }
 
    public boolean equals(HourlyEmployee other)
    {
       return (getName( ).equals(other.getName( )) 
                && getAFM( ) == other.getAFM( )
                && wageRate == other.wageRate
                && hours == other.hours);
    }
	
	public static void main(String[] args){
		HourlyEmployee emp = new HourlyEmployee("Alice", 1);
		System.out.println(emp);
	}
}
