// To paradeigma poy kataskeyasame sthn tajh

class StackElement
{
	private int value;
	private StackElement next = null;
	
	public StackElement(int value){
		this.value = value;
	}
	
	public int getValue(){
		return value;
	}
	
	public StackElement getNext(){
		return next;
	}
	
	public void setNext(StackElement element){
		next = element;
	}
	
}

class Stack
{
	private StackElement head;
	private int size = 0;
	
	public int pop(){
		if (size == 0){ // head == null
			System.out.println("Pop from empty stack");
			System.exit(-1);
		}
		int value = head.getValue();
		head = head.getNext();
		size --;
		return value;
	}
	
	public void push(int value){
		StackElement element = new StackElement(value);
		element.setNext(head);
		head = element;
		size ++;
	}
	
}

class StackExample
{
	public static void main(String[] args){
		Stack s = new Stack();
		s.push(3);
		s.push(2);
		s.push(1);
		System.out.println(s.pop());
		System.out.println(s.pop());
		System.out.println(s.pop());
		System.out.println(s.pop());		
	}
}




