class IntStackElement
{
	private int value;
	private IntStackElement next;
	
	public IntStackElement(int val){
		value = val;
	}
	
	public void setNext(IntStackElement element){
		next = element;
	}
	
	public IntStackElement getNext(){
		return next;
	}
	
	public int getValue(){
		return value;
	}
	
}

class IntStack
{
	private IntStackElement head;
	private int size = 0;
	
	public void push(int value){
		IntStackElement element = new IntStackElement(value);
		element.setNext(head);
		head = element;
		size ++;
	}
	
	public int pop(){
		if (size == 0){
			System.exit(-1);
		}
		int value = head.getValue();
		head = head.getNext();
		size -- ;
		return value;
	}
	
	public String toString(){
		String returnString = "";
		IntStackElement e = head;
		while(e != null){
			returnString = returnString + e.getValue() + " ";
			e = e.getNext();
		}
		return returnString;
	}
	
	public static void main(String[] args){
		IntStack stack = new IntStack();
		stack.push(10);
		stack.push(3);
		stack.push(1);
		System.out.println(stack);
		System.out.println(stack.pop());
		System.out.println(stack.pop());
		System.out.println(stack.pop());
	}
}