class Stack
{
	private int capacity;
	private int size = 0;
	private int[] elements;
	
	public Stack(int capacity){
		this.capacity = capacity;
		elements = new int[capacity];
	}
	
	public void push(int element){
		if (size == capacity){
			System.out.println("Cannot enter any more elements");
			return;
		}
		elements[size] = element;
		size ++;
	}
	
	public int pop(){
		if (size == 0){
			System.out.println("No elements to pop. Exiting...");
			System.exit(-1);
		}
		size -- ;
		return elements[size];
	}
	
	public boolean isEmpty(){
		return (size == 0);
	}
	
	public String toString(){
		String returnString = "";
		for (int i = 0; i < size; i ++){
			returnString = returnString + elements[i] + " ";
		}
		return returnString;
	}
	
	public boolean equals(Stack other){
		if (this.size != other.size){
			return false;
		}
		for (int i = 0; i < size; i ++){
			if (this.elements[i] != other.elements[i]){
				return false;
			}
		}
		return true;
	}
}
