class Person
{
	private String name;
	
	public Person(String name){
		this.name = name;
	}
	
	public String toString(){
		return name;
	}
}

class CarWithPassengers
{
	private int CAR_SIZE = 4;
	private int position;
	private Person[] passengers = new Person[CAR_SIZE];
	private int numOfPassengers = 0;
	
	public CarWithPassengers() {}
	
	public CarWithPassengers(int position)
	{
		this.position = position;
	}
	
	public void addPassenger(Person passenger)
	{
		if (numOfPassengers < CAR_SIZE){
			passengers[numOfPassengers] = passenger;
			numOfPassengers ++;
		}
	}
	
	public String toString(){
		String retValue = "Car at "+position +" with passengers: ";
		for (int i = 0; i < numOfPassengers; i ++){
			retValue += passengers[i]+ " ";
		}
		return retValue;
	}
	
	public static void main(String[] args){
		CarWithPassengers myCar = new CarWithPassengers();
		Person alice = new Person("Alice");
		myCar.addPassenger(alice);
		Person bob = new Person("Bob");
		myCar.addPassenger(bob);
		System.out.println(myCar);
	}
}