
import java.util.Scanner;

public class DivisionDemoThirdVersion
{
   public static void main(String[] args)
   {
        Scanner keyboard = new Scanner(System.in);

        try
        {
           System.out.println("Enter numerator:"); 
           int numerator = keyboard.nextInt();
           System.out.println("Enter denominator:"); 
           int denominator = keyboard.nextInt();

           int percentage = safePercentage(numerator, denominator);
           System.out.println("percentage  = " + percentage +"%");
        }
        catch(DivisionByZeroException e)
        {
            System.out.println(e.getMessage( ));
            System.exit(0);
        }

        System.out.println("End of program.");
   }
   

   public static int safePercentage(int top, int bottom) throws DivisionByZeroException
   {
		double ratio = safeDivide(top,bottom);
		return (int)(ratio*100);
	}
	
			
   public static double safeDivide(int top, int bottom) 
                             throws DivisionByZeroException
   {
       if (bottom == 0)
           throw new DivisionByZeroException( );

       return top/(double)bottom;
   }

}
 
