abstract class Ticket
{
	private int number;
	private boolean student;
	
	public Ticket(int number, boolean student){	
		this.number = number;
		this.student = student;
	}
	
	public abstract double getPrice();
	
	public double finalPrice(){
		if (student){
			return getPrice()*0.5;
		}
		return getPrice();
	}
	
	public String toString(){
		return "Ticket "+ number + ", price:" + finalPrice();
	}
}

class AdvanceTicket extends Ticket
{
	private int numOfDays;
	
	public AdvanceTicket(int number, boolean student, int numOfDays){
		super(number,student);
		this.numOfDays = numOfDays;
	}
	
	public double getPrice(){
		if (numOfDays <=10){
			return 40;
		}else{
			return 30;
		}
	}
}

class WalkInTicket extends Ticket
{
	public WalkInTicket(int number, boolean student){
		super(number, student);
	}
	
	public double getPrice(){
		return 50;
	}
}

class Test
{
	public static void main(String[] args){
		WalkInTicket t1 = new WalkInTicket(123,true);
		AdvanceTicket t2 = new AdvanceTicket(132,false,10);
		System.out.println(t1);
		System.out.println(t2);
	}
}