class ObjectStackElement
{
	private Object value;
	private ObjectStackElement next;
	
	public ObjectStackElement(Object val){
		value = val;
	}
	
	public void setNext(ObjectStackElement element){
		next = element;
	}
	
	public ObjectStackElement getNext(){
		return next;
	}
	
	public Object getValue(){
		return value;
	}
	
}

class ObjectStack
{
	private ObjectStackElement head;
	private int size = 0;
	
	public Object pop(){
	  if (size == 0){ // head == null
		System.out.println("Pop from empty stack");
		System.exit(-1);
	  }
	  Object value = head.getValue();
	  head = head.getNext();
	  size --;
	  return value;
	}
	
	public void push(Object value){
	  ObjectStackElement element = new ObjectStackElement(value);
	  element.setNext(head);
	  head = element;
	  size ++;
	}
	
}

public class ObjectStackTest
{
  public static void main(String[] args){
    ObjectStack stack = new ObjectStack();

    Person p = new Person("Alice", 1);
    Integer i = new Integer(10);
    String s = "a random string";

    stack.push(p);
    stack.push(i);
    stack.push(s);
  }	
}
