import javax.swing.JFrame;
import javax.swing.JButton;
import javax.swing.JLabel;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;


public class MultiButtonWindow extends JFrame implements ActionListener
{
    public static final int WIDTH = 300; 
    public static final int HEIGHT = 200;

    public MultiButtonWindow( )
    {
        super( "Multi-Color");
        setSize(WIDTH, HEIGHT);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		setLayout(new FlowLayout());
        JLabel label = new JLabel("Pick A Color");
		add(label);
		JButton blueButton = new JButton("Blue");
  		blueButton.addActionListener(this);
		add(blueButton);       
		JButton redButton = new JButton("Red");
 		redButton.addActionListener(this);
        add(redButton);
        JButton endButton = new JButton("Exit");
		endButton.addActionListener(this);
        add(endButton);
    }
	
	public void actionPerformed(ActionEvent e) 
    {
		String buttonType = e.getActionCommand();
		switch (buttonType){
			case "Blue": 
				getContentPane().setBackground(Color.BLUE);
				break;
			case "Red":
				getContentPane().setBackground(Color.RED);
				break;		
			case "Exit":
				System.exit(0);
		}
    }
	
	public static void main(String args[]){
		MultiButtonWindow w = new MultiButtonWindow();
		w.setVisible(true);
	}
}
