class Person
{
    private String name;
    private int number;

    public Person(String initName, int initNumber){
        name = initName;
        number = initNumber;
    }
	
	public Person(Person other){
        this.name = other.name;
        this.number = other.number;
    }

    public void set(String newName, int newNumber){
        name = newName;
        number = newNumber;
    }

    public String toString( ){
        return (name + " " + number);
    }
	
	public boolean equals(Person other){
		return (this.name.equals(other.name) && this.number == other.number);
	}
}

public class CarDriver
{
    private int position;
    private Person driver;
	
    public CarDriver(int position, String name, int number){
         this.position = position;
		 driver = new Person(name, number);
    }
	
	public CarDriver(CarDriver other){
		this.position = other.position;
		driver = new Person(other.driver); 
    }

    public void move(){
		position ++;
	}

	public String toString(){
		return driver + ", position: " + position;
    }	
	
	public boolean equals(CarDriver other)
	{
		return this.driver.equals(other.driver) && this.position == other.position;
	}

    public static void main(String args[]){
		CarDriver car1 = new CarDriver(1,"Alice",1);
		car1.move();
		System.out.println(car1);
		CarDriver car2 = new CarDriver(car1);
		car2.move();
		System.out.println(car2);
		System.out.println(car2.equals(car1));
    }
}
